local addonName, ns = ...
ns.Utils = {}

-- 🔇 Error Filter
local ErrorFilter = CreateFrame("Frame")
ErrorFilter:RegisterEvent("UI_ERROR_MESSAGE")
ErrorFilter:SetScript("OnEvent", function(self, event, msg)
    if msg == "Ability is not ready yet." or 
       msg == "Not enough energy" or 
       msg == "Not enough mana" or 
       msg == "Spell is not ready yet." or
       msg == "Target needs to be in front of you." then
        UIErrorsFrame:Clear()
    end
end)

-- 🏷️ Tag System (Smart Macro Translator)
local tags = {
    ["HUNTER"] = {
        ["@EXECUTE"] = "/cast Kill Shot",
        ["@INTERRUPT"] = "/cast Silencing Shot",
        ["@BIG_CD"] = "/cast Bestial Wrath",
        ["@MISDIRECT"] = "/cast [target=pet,exists] Misdirection"
    },
    ["WARRIOR"] = {
        ["@EXECUTE"] = "/cast Execute",
        ["@INTERRUPT"] = "/cast Pummel",
        ["@BIG_CD"] = "/cast Recklessness"
    },
    ["PRIEST"] = {
        ["@EXECUTE"] = "/cast Shadow Word: Death",
        ["@INTERRUPT"] = "/cast Silence",
        ["@BIG_CD"] = "/cast Power Infusion"
    },
    ["DEFAULT"] = {
        ["@EXECUTE"] = "",
        ["@INTERRUPT"] = "",
        ["@BIG_CD"] = "",
        ["@MISDIRECT"] = ""
    }
}

function ns.Utils.ParseTags(text, class)
    if not text then return "" end
    local classTags = tags[class] or tags["DEFAULT"]
    
    -- Replace known tags
    for tag, replacement in pairs(classTags) do
        text = string.gsub(text, tag, replacement)
    end
    
    -- Fallback for tags not in class list (use default empty)
    for tag, replacement in pairs(tags["DEFAULT"]) do
        text = string.gsub(text, tag, replacement)
    end
    
    return text
end

-- 📦 Wrap Macro (Trinkets + Safety)
function ns.Utils.WrapMacro(text)
    local prefix = "/console Sound_EnableSFX 0\n/use 13\n/use 14\n/use 10\n"
    local suffix = "\n/console Sound_EnableSFX 1\n/script UIErrorsFrame:Clear()"
    return prefix .. text .. suffix
end
