local addonName, ns = ...
ns.UI = {}

local frame, editBox
local currentBtn = 1

-- Button Labels
local btnLabels = {
    [1] = "MAIN",
    [2] = "AOE",
    [3] = "PANIC",
    [4] = "CC",
    [5] = "BURST"
}

function ns.UI.Init()
    frame = CreateFrame("Frame", "LazyAssistantGUI", UIParent)
    frame:SetSize(500, 430) -- Taller to fit help text
    frame:SetPoint("CENTER")
    frame:SetBackdrop({
        bgFile = "Interface/DialogFrame/UI-DialogBox-Background", 
        edgeFile = "Interface/DialogFrame/UI-DialogBox-Border", 
        tile = true, tileSize = 32, edgeSize = 32, 
        insets = { left = 8, right = 8, top = 8, bottom = 8 }
    })
    frame:SetBackdropColor(0, 0, 0, 0.9)
    frame:EnableMouse(true)
    frame:SetMovable(true)
    frame:RegisterForDrag("LeftButton")
    frame:SetScript("OnDragStart", frame.StartMoving)
    frame:SetScript("OnDragStop", function(self)
        self:StopMovingOrSizing()
        local p, _, _, x, y = self:GetPoint()
        LazyAssistantDB.point = p; LazyAssistantDB.x = x; LazyAssistantDB.y = y
    end)
    frame:Hide()
    tinsert(UISpecialFrames, "LazyAssistantGUI") 

    local title = frame:CreateFontString(nil, "OVERLAY", "GameFontNormalLarge")
    title:SetPoint("TOP", 0, -12)
    title:SetText("LazyAssistant v5.1")

    -- Info Text
    local info = frame:CreateFontString(nil, "OVERLAY", "GameFontHighlightSmall")
    info:SetPoint("TOP", 0, -35)
    info:SetText("Select a macro slot below to edit.")

    -- Button Selectors (1-5)
    for i = 1, 5 do
        local b = CreateFrame("Button", nil, frame, "GameMenuButtonTemplate")
        b:SetSize(60, 25) -- Wider buttons
        b:SetPoint("TOPLEFT", 20 + ((i-1)*70), -60)
        b:SetText(btnLabels[i]) -- Smart Names
        b:SetScript("OnClick", function() ns.UI.LoadMacro(i) end)
    end

    -- Editor Title
    local editTitle = frame:CreateFontString("LazyEditTitle", "OVERLAY", "GameFontNormal")
    editTitle:SetPoint("TOPLEFT", 25, -95)
    editTitle:SetText("Editing: MAIN (Single Target)")

    -- Scroll Editor
    local scroll = CreateFrame("ScrollFrame", "LazyAssistantScrollFrame", frame, "UIPanelScrollFrameTemplate")
    scroll:SetPoint("TOPLEFT", 20, -120)
    scroll:SetPoint("BOTTOMRIGHT", -30, 50)

    editBox = CreateFrame("EditBox", "LazyAssistantEditBox", scroll)
    editBox:SetMultiLine(true)
    editBox:SetFontObject(ChatFontNormal)
    editBox:SetWidth(450)
    editBox:SetHeight(300)
    editBox:SetAutoFocus(false)
    editBox:SetScript("OnEscapePressed", function(self) self:ClearFocus() end)
    scroll:SetScrollChild(editBox)

    -- Save
    local save = CreateFrame("Button", nil, frame, "GameMenuButtonTemplate")
    save:SetPoint("BOTTOMRIGHT", -20, 15)
    save:SetSize(80, 25)
    save:SetText("Save")
    save:SetScript("OnClick", function()
        if InCombatLockdown() then print("Error: In Combat") return end
        ns.DB.SaveMacro(currentBtn, editBox:GetText())
        ns.Engine.UpdateAll()
        frame:Hide()
        print("|cFF00FF00LazyAssistant:|r Saved " .. btnLabels[currentBtn])
    end)

    -- Reset
    local reset = CreateFrame("Button", nil, frame, "GameMenuButtonTemplate")
    reset:SetPoint("BOTTOMLEFT", 20, 15)
    reset:SetSize(80, 25)
    reset:SetText("Reset")
    reset:SetScript("OnClick", function()
        if InCombatLockdown() then return end
        ns.DB.ResetToDefaults()
        ns.UI.LoadMacro(currentBtn)
        ns.Engine.UpdateAll()
    end)
end

function ns.UI.LoadMacro(index)
    currentBtn = index
    editBox:SetText(ns.DB.GetMacro(index))
    _G["LazyEditTitle"]:SetText("Editing: " .. btnLabels[index])
end

function ns.UI.Toggle()
    if frame:IsShown() then frame:Hide() else frame:Show() end
end
