local addonName, ns = ...
ns.Templates = {}

local commonStart = [[
/cleartarget [dead][noexists]
/targetenemy [noexists]
/startattack
]]

-- ============================================================================
-- 🏹 HUNTER (Beast Mastery)
-- ============================================================================
ns.Templates["HUNTER"] = {
    [1] = commonStart .. [[
/petattack
/petautocaston Growl
@MISDIRECT
@BIG_CD
/cast [target=pettarget,exists] Kill Command
@EXECUTE
/castsequence reset=target/combat Serpent Sting, Steady Shot, Arcane Shot, Steady Shot, Steady Shot, Arcane Shot
]],
    [2] = [[
/startattack
/petattack
/cast Multi-Shot
/cast Volley
]],
    [3] = [[
/cast Deterrence
/cast Disengage
/cast Feign Death
]],
    [4] = [[
/cast Freezing Trap
/cast Frost Trap
]],
    [5] = [[
/cast Aspect of the Dragonhawk
/cast Aspect of the Viper
]]
}

-- ============================================================================
-- ⚔️ WARRIOR (Arms/Fury Hybrid Leveling)
-- ============================================================================
ns.Templates["WARRIOR"] = {
    [1] = commonStart .. [[
/cast Charge
@BIG_CD
@EXECUTE
/castsequence reset=target/combat Rend, Mortal Strike, Overpower, Slam, Heroic Strike
/cast Victory Rush
/cast Bloodthirst
]],
    [2] = [[
/cast Sweeping Strikes
/cast Bladestorm
/cast Cleave
/cast Whirlwind
]],
    [3] = [[
/cast Shield Wall
/cast Enraged Regeneration
/cast Shield Block
]],
    [4] = [[
@INTERRUPT
/cast Intimidating Shout
/cast Hamstring
]],
    [5] = [[
/cast Battle Shout
/cast Commanding Shout
]]
}

-- ============================================================================
-- 🛡️ PALADIN (Retribution)
-- ============================================================================
ns.Templates["PALADIN"] = {
    [1] = commonStart .. [[
@BIG_CD
@EXECUTE
/castsequence reset=8 Judgement of Light, Crusader Strike, Divine Storm, Consecration, Exorcism
/cast Divine Plea
]],
    [2] = [[
/cast Divine Storm
/cast Consecration
/cast Holy Wrath
]],
    [3] = [[
/cast Divine Shield
/cast Divine Protection
/cast Lay on Hands
]],
    [4] = [[
/cast Hammer of Justice
/cast Repentance
]],
    [5] = [[
/cast Greater Blessing of Might
/cast Greater Blessing of Kings
]]
}

-- ============================================================================
-- 💀 DEATH KNIGHT (Unholy/Blood Leveling)
-- ============================================================================
ns.Templates["DEATHKNIGHT"] = {
    [1] = commonStart .. [[
/petattack
/cast Icy Touch
/cast Plague Strike
/cast Heart Strike
/cast Scourge Strike
/cast Death Strike
/cast Death Coil
]],
    [2] = [[
/cast Death and Decay
/cast Pestilence
/cast Blood Boil
]],
    [3] = [[
/cast Icebound Fortitude
/cast Anti-Magic Shell
/cast Vampiric Blood
]],
    [4] = [[
/cast Mind Freeze
/cast Strangulate
/cast Death Grip
]],
    [5] = [[
/cast Horn of Winter
/cast Raise Dead
]]
}

-- ============================================================================
-- ⛪ PRIEST (Shadow)
-- ============================================================================
ns.Templates["PRIEST"] = {
    [1] = [[
/targetenemy [noexists][dead]
/cast [noform] Shadowform
@BIG_CD
@EXECUTE
/castsequence reset=target/combat Vampiric Touch, Devouring Plague, Mind Blast, Mind Flay, Mind Flay
]],
    [2] = [[
/cast Mind Sear
/cast Holy Nova
]],
    [3] = [[
/cast Power Word: Shield
/cast Dispersion
/cast Fade
]],
    [4] = [[
@INTERRUPT
/cast Psychic Scream
]],
    [5] = [[
/cast Power Word: Fortitude
/cast Divine Spirit
/cast Shadow Protection
]]
}

-- ============================================================================
-- 🔥 MAGE (Arcane/Frost)
-- ============================================================================
ns.Templates["MAGE"] = {
    [1] = [[
/targetenemy [noexists][dead]
@BIG_CD
/cast [mod:alt] Arcane Missiles
/castsequence reset=target/combat Arcane Blast, Arcane Blast, Arcane Blast, Arcane Barrage
/cast Frostbolt
]],
    [2] = [[
/cast Blizzard
/cast Arcane Explosion
/cast Frost Nova
]],
    [3] = [[
/cast Ice Block
/cast Ice Barrier
/cast Mana Shield
]],
    [4] = [[
@INTERRUPT
/cast Polymorph
]],
    [5] = [[
/cast Arcane Intellect
/cast Molten Armor
/cast Conjure Refreshment
]]
}

-- ============================================================================
-- 😈 WARLOCK (Destruction/Affliction)
-- ============================================================================
ns.Templates["WARLOCK"] = {
    [1] = [[
/targetenemy [noexists][dead]
/petattack
@BIG_CD
/castsequence reset=target/combat Immolate, Curse of Agony, Corruption, Chaos Bolt, Incinerate, Incinerate, Conflagrate
/cast Shadow Bolt
]],
    [2] = [[
/cast Rain of Fire
/cast Seed of Corruption
]],
    [3] = [[
/cast Death Coil
/cast Fear
/cast Howl of Terror
]],
    [4] = [[
@INTERRUPT
/cast Banish
]],
    [5] = [[
/cast Fel Armor
/cast Create Healthstone
/cast Summon Imp
]]
}

-- ============================================================================
-- 🗡️ ROGUE (Combat)
-- ============================================================================
ns.Templates["ROGUE"] = {
    [1] = commonStart .. [[
/cast Sinister Strike
/cast Eviscerate
/cast Killing Spree
/cast Adrenaline Rush
/cast Blade Flurry
]],
    [2] = [[
/cast Fan of Knives
/cast Blade Flurry
]],
    [3] = [[
/cast Evasion
/cast Cloak of Shadows
/cast Vanish
]],
    [4] = [[
@INTERRUPT
/cast Kidney Shot
/cast Gouge
]],
    [5] = [[
/use Instant Poison IX
/use Deadly Poison IX
]]
}

-- ============================================================================
-- 🐻 DRUID (Feral/Balance Hybrid)
-- ============================================================================
ns.Templates["DRUID"] = {
    [1] = commonStart .. [[
/cast [nostance] Cat Form
/cast [stance:3] Mangle (Cat)
/cast [stance:3] Rake
/cast [stance:3] Rip
/cast [stance:3] Ferocious Bite
/cast [stance:1] Maul
/cast [stance:1] Mangle (Bear)
/cast Starfire
/cast Wrath
]],
    [2] = [[
/cast Swipe (Cat)
/cast Swipe (Bear)
/cast Hurricane
]],
    [3] = [[
/cast Barkskin
/cast Survival Instincts
/cast Frenzied Regeneration
]],
    [4] = [[
/cast Bash
/cast Cyclone
/cast Entangling Roots
]],
    [5] = [[
/cast Mark of the Wild
/cast Thorns
/cast Omen of Clarity
]]
}

-- ============================================================================
-- ⚡ SHAMAN (Elemental)
-- ============================================================================
ns.Templates["SHAMAN"] = {
    [1] = [[
/targetenemy [noexists][dead]
@BIG_CD
/cast Lava Burst
/cast Chain Lightning
/cast Lightning Bolt
/cast Earth Shock
]],
    [2] = [[
/cast Chain Lightning
/cast Magma Totem
/cast Fire Nova
]],
    [3] = [[
/cast Astral Shift
/cast Shamanistic Rage
/cast Stoneclaw Totem
]],
    [4] = [[
@INTERRUPT
/cast Hex
/cast Thunderstorm
]],
    [5] = [[
/cast Water Shield
/cast Flametongue Weapon
/cast Call of the Elements
]]
}

-- Generic fallback
local generic = {
    [1] = commonStart,
    [2] = "", [3] = "", [4] = "", [5] = ""
}

setmetatable(ns.Templates, {__index = function() return generic end})
