local addonName, ns = ...
ns.DB = {}

local playerClass = select(2, UnitClass("player"))

function ns.DB.Init()
    LazyAssistantDB = LazyAssistantDB or { 
        point = "CENTER", x = 0, y = 0, visible = true, 
        macros = {} 
    }
    
    -- Structure: DB.macros[CLASS][SPEC_GROUP][BUTTON_INDEX]
    if not LazyAssistantDB.macros[playerClass] then
        LazyAssistantDB.macros[playerClass] = {}
    end
end

function ns.DB.GetMacro(index)
    local spec = GetActiveTalentGroup() or 1 -- 1 or 2 (Dual Spec)
    
    -- Ensure tables exist
    if not LazyAssistantDB.macros[playerClass][spec] then
        LazyAssistantDB.macros[playerClass][spec] = {}
    end
    
    local text = LazyAssistantDB.macros[playerClass][spec][index]
    
    -- Load template if empty
    if not text or text == "" then
        text = ns.Templates[playerClass][index] or ""
    end
    
    return text
end

function ns.DB.SaveMacro(index, text)
    local spec = GetActiveTalentGroup() or 1
    LazyAssistantDB.macros[playerClass][spec][index] = text
end

function ns.DB.ResetToDefaults()
    local spec = GetActiveTalentGroup() or 1
    LazyAssistantDB.macros[playerClass][spec] = {} -- Wipe custom
end
